#pragma GCC optimize("Ofast,O3,unroll-loops")
#pragma GCC target("avx2")

#include <bits/stdc++.h>

using namespace std;

#define SZ(s) ((int)s.n())
#define all(x) (x).begin(), (x).end()
#define lla(x) (x).rbegin(), (x).rend()
#define bpc(x) __builtin_popcount(x)
#define bpcll(x) __builtin_popcountll(x)
#define MP make_pair
//#define endl '\n'

mt19937 rng(chrono::high_resolution_clock::now().time_since_epoch().count());

typedef long long ll;
const int MOD = 1e9 + 7;
const int N = 1e6 + 3e2;

using point = pair<int, int>;
#define x first
#define y second

struct seg{
    point p1, p2;
    seg(){};
    seg(point _p1, point _p2){
        p1 = _p1, p2 = _p2;
    }
};

int magic(point p, seg l){
    if (l.p1.x == l.p2.x){
        int x = l.p1.x;
        if (p.x == x) return 0;
        return p.x < x ? -1 : 1;
    }

    long double k = (long double) (l.p1.y - l.p2.y) / (l.p1.x - l.p2.x);
    long double b = l.p1.y - l.p1.x * k;

    long double y = p.x * k + b;

    if (abs(p.y - y) < 1e-5) return 0;

    return p.y < y ? -1 : 1;
}

bool intersect(seg l, seg r){
    if (magic(l.p1, r) * magic(l.p2, r) == 1) return false;
    if (magic(r.p1, l) * magic(r.p2, l) == 1) return false;
    return true;
}

int p[N];
int find(int v){
    return (v == p[v] ? v : p[v] = find(p[v]));
}

bool unite(int u, int v){
    u = find(u);
    v = find(v);
    if (u == v) return false;
    if (rng() & 1) swap(u, v);
    p[u] = v;
    return true;
}

void solve(){
    int n;
    cin >> n;

    iota(p, p + n, 0);

    ll ans = 1;

    vector<seg> segments;
    for (int i = 0; i < n; i++){
        point p1, p2;
        cin >> p1.x >> p1.y >> p2.x >> p2.y;

        seg cur = seg(p1, p2);

        map<int, int> mp;
        for (int j = 0; j < i; j++){
            seg prv = segments[j];

            if (intersect(cur, prv)) mp[find(j)]++;

        }

        for (auto [val, cnt] : mp) ans += cnt - 1;

        for (int j = 0; j < i; j++){
            seg prv = segments[j];
            if (intersect(cur, prv)) unite(i, j);
        }

        segments.emplace_back(cur);
    }

    cout << ans << endl;

}

int main(){
    clock_t startTime = clock();
    ios_base::sync_with_stdio(false);

#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif

    int test_cases = 1;
    cin >> test_cases;

    for (int test = 1; test <= test_cases; test++){
        // cout << (solve() ? "YES" : "NO") << endl;
        solve();
    }

    cerr << "Time: " << int((double) (clock() - startTime) / CLOCKS_PER_SEC * 1000) << " ms" << endl;

    return 0;
}